"use client"

import * as React from "react"
import { Check, ChevronsUpDown } from "lucide-react"

import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu"
import {
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
} from "@/components/ui/sidebar"
import Image from "next/image"
import { useRouter } from "@/lib/navigation.router"

export function ApplicationPlatform({
  platforms: versions,
  defaultPlatform: defaultVersion,
}: {
  platforms?: string[]
  defaultPlatform?: string
}) {
  const [selectedPlatform, setSelectedPlatform] = React.useState(defaultVersion)
  const router = useRouter()

  const trigger = (
    <>
      <div className="flex aspect-square size-8 items-center justify-center rounded-lg bg-sidebar-primary text-sidebar-primary-foreground">
        <Image
          src={"/favicon.ico"}
          alt="MDOT GTFS Administration Icon"
          className="size-5"
          width={64}
          height={64}
        />
      </div>
      <div className="flex flex-col gap-0.5 leading-none">
        <span className="font-semibold">MiTripPlanner</span>
        <span className="">
          {selectedPlatform
            ? `v${selectedPlatform}`
            : 'Administration Portal'
          }
        </span>
      </div>

      {
        (versions?.length ?? 0) > 1
          ? <ChevronsUpDown className="ml-auto" />
          : null
      }
    </>
  )

  if (!versions || versions.length <= 1) {
    return (
      <SidebarMenuButton
        size="lg"
        className="data-[state=open]:bg-sidebar-accent data-[state=open]:text-sidebar-accent-foreground"
        onClick={() => router.push('/')}
      >
        {trigger}
      </SidebarMenuButton>
    )
  }

  return (
    <SidebarMenu>
      <SidebarMenuItem>
        <DropdownMenu>
          <DropdownMenuTrigger asChild>
            <SidebarMenuButton
              size="lg"
              className="data-[state=open]:bg-sidebar-accent data-[state=open]:text-sidebar-accent-foreground"
            >
              {trigger}
            </SidebarMenuButton>
          </DropdownMenuTrigger>
          <DropdownMenuContent
            className="w-[--radix-dropdown-menu-trigger-width]"
            align="start"
          >
            {versions.map((version) => (
              <DropdownMenuItem
                key={version}
                onSelect={() => setSelectedPlatform(version)}
              >
                v{version}{" "}
                {version === selectedPlatform && <Check className="ml-auto" />}
              </DropdownMenuItem>
            ))}
          </DropdownMenuContent>
        </DropdownMenu>
      </SidebarMenuItem>
    </SidebarMenu>
  )
}

